#include "scripts.h"
#include "engine.h"
#include "iran_scripts.h"

void Iran_Beaconing_Prevention_Zone::Entered(GameObject *obj,GameObject *enter) 
{																		 
	Commands->Start_Timer(obj,this,0.1,Commands->Get_ID(enter));
}

void Iran_Beaconing_Prevention_Zone::Timer_Expired(GameObject *obj,int number)
{
	GameObject* checkplayerobj = Commands->Find_Object(number);
	if ( IsInsideZone(obj,checkplayerobj)) {
		Commands->Start_Timer(obj,this,0.5,number);		
		const char* currentweapon = Get_Current_Weapon(checkplayerobj);
		if (strcmp(currentweapon, "CnC_Weapon_NukeBeacon_Player") == 0  ||
			 strcmp(currentweapon,"CnC_Weapon_IonCannonBeacon_Player") == 0 ) {
			if (Commands->Get_Player_Type(checkplayerobj) == 0) {
				Remove_Weapon(checkplayerobj,"CnC_Weapon_NukeBeacon_Player");
				Grant_Powerup(checkplayerobj,"CnC_POW_Nuclear_Missle_Beacon");
			}
			if (Commands->Get_Player_Type(checkplayerobj) == 1) {
				Remove_Weapon(checkplayerobj,"CnC_Weapon_IonCannonBeacon_Player");
				Grant_Powerup(checkplayerobj,"CnC_POW_IonCannonBeacon_Player");
			}
		}		
	}
}

void Iran_Vehicle_All_Kill_Zone::Entered(GameObject *obj,GameObject *enter)
{
	if (Is_Vehicle(enter))
	{
		int type = Commands->Get_Player_Type(enter);
		if ( type < 0 || type > 1 )
		{
			return;
		}
		saved = Commands->Get_ID(enter);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
	}
}

void Iran_Vehicle_All_Kill_Zone::Timer_Expired(GameObject *obj,int number)
{
	if (IsInsideZone(obj, Commands->Find_Object(saved)))
	{
		Commands->Apply_Damage(Commands->Find_Object(saved), 9999.0f, "Blamo", 0);
	}
}

void Iran_All_Kill_Zone::Entered(GameObject *obj,GameObject *enter)
{
	int type = Commands->Get_Player_Type(enter);
	if ( type < 0 || type > 1 )
	{
		return;
	}
	saved = Commands->Get_ID(enter);
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
}

void Iran_All_Kill_Zone::Timer_Expired(GameObject *obj,int number)
{
	if (IsInsideZone(obj, Commands->Find_Object(saved)))
	{
		Commands->Apply_Damage(Commands->Find_Object(saved), 9999.0f, "Blamo", 0);
	}
}

void Iran_Star_Kill_Zone::Entered(GameObject *obj,GameObject *enter)
{
	int type = Commands->Get_Player_Type(enter);
	if ( type < 0 || type > 1 )
	{
		return;
	}
	saved = Commands->Get_ID(enter);
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
}

void Iran_Star_Kill_Zone::Timer_Expired(GameObject *obj,int number)
{
	if (IsInsideZone(obj, Commands->Find_Object(saved)))
	{
		Commands->Apply_Damage(Commands->Find_Object(saved), 9999.0f, "Blamo", 0);
	}
}

void Iran_Vehicle_Ground_Kill_Zone::Entered(GameObject *obj,GameObject *enter)
{
	if (Is_Vehicle(enter))
	{
		if (Get_Vehicle_Mode(enter) != FLYING)
		{
			int type = Commands->Get_Player_Type(enter);
			if ( type < 0 || type > 1 )
			{
				return;
			}
			saved = Commands->Get_ID(enter);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
		}
	}
}

void Iran_Vehicle_Ground_Kill_Zone::Timer_Expired(GameObject *obj,int number)
{
	if (IsInsideZone(obj, Commands->Find_Object(saved)))
	{
		Commands->Apply_Damage(Commands->Find_Object(saved), 9999.0f, "Blamo", 0);
	}
}

void Iran_Vehicle_Flying_Kill_Zone::Entered(GameObject *obj,GameObject *enter)
{
	if (Is_Vehicle(enter))
	{
		if (Get_Vehicle_Mode(enter) == FLYING)
		{
			int type = Commands->Get_Player_Type(enter);
			if ( type < 0 || type > 1 )
			{
				return;
			}
			saved = Commands->Get_ID(enter);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),1);
		}
	}
}

void Iran_Vehicle_Flying_Kill_Zone::Timer_Expired(GameObject *obj,int number)
{
	if (IsInsideZone(obj, Commands->Find_Object(saved)))
	{
		Commands->Apply_Damage(Commands->Find_Object(saved), 9999.0f, "Blamo", 0);
	}
}

ScriptRegistrant<Iran_Beaconing_Prevention_Zone> Iran_Beaconing_Prevention_Zone_Registrant("Iran_Beaconing_Prevention_Zone", "");
ScriptRegistrant<Iran_Vehicle_All_Kill_Zone> Iran_Vehicle_All_Kill_Zone_Registrant("Iran_Vehicle_All_Kill_Zone", "Time:float");
ScriptRegistrant<Iran_All_Kill_Zone> Iran_All_Kill_Zone_Registrant("Iran_All_Kill_Zone", "Time:float");
ScriptRegistrant<Iran_Star_Kill_Zone> Iran_Star_Kill_Zone_Registrant("Iran_Star_Kill_Zone", "Time:float");
ScriptRegistrant<Iran_Vehicle_Ground_Kill_Zone> Iran_Vehicle_Ground_Kill_Zone_Registrant("Iran_Vehicle_Ground_Kill_Zone", "Time:float");
ScriptRegistrant<Iran_Vehicle_Flying_Kill_Zone> Iran_Vehicle_Flying_Kill_Zone_Registrant("Iran_Vehicle_Flying_Kill_Zone", "Time:float");
